//
//  TouchExplorerViewController.m
//  TouchExplorer
//
//  Created by Robert Górczyński on 11-07-25.
//

#import "TouchExplorerViewController.h"

@implementation TouchExplorerViewController
@synthesize messageLabel;
@synthesize tapsLabel; 
@synthesize touchesLabel; 

- (void)updateLabelsFromTouches:(NSSet *)touches { 
    NSUInteger numTaps = [[touches anyObject] tapCount]; 
    NSString *tapsMessage = [[NSString alloc] 
							 initWithFormat:@"Wykryto %d naciśnięć", numTaps]; 
    tapsLabel.text = tapsMessage; 
    [tapsMessage release]; 
	
    NSUInteger numTouches = [touches count]; 
    NSString *touchMsg = [[NSString alloc] initWithFormat: 
						  @"Wykryto %d dotknięcie", numTouches]; 
    touchesLabel.text = touchMsg; 
    [touchMsg release]; 
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.messageLabel = nil; 
    self.tapsLabel = nil; 
    self.touchesLabel = nil; 
    [super viewDidUnload]; 	
}


- (void)dealloc {
    [messageLabel release]; 
    [tapsLabel release]; 
    [touchesLabel release]; 	
    [super dealloc];
}

#pragma mark - 
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event { 
    messageLabel.text = @"Metoda touchesBegan."; 
    [self updateLabelsFromTouches:touches]; 
} 

- (void)touchesCancelled:(NSSet *)touches withEvent:(UIEvent *)event{ 
    messageLabel.text = @"Metoda touchesCancelled."; 
    [self updateLabelsFromTouches:touches]; 
} 

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event { 
    messageLabel.text = @"Metoda touchesEnded."; 
    [self updateLabelsFromTouches:touches]; 
}

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event { 
    messageLabel.text = @"Wykryto przeciągnięcie."; 
    [self updateLabelsFromTouches:touches]; 
} 

@end
